# Relay

- [Documentation](https://relay.so/docs)
- [Twitter](https://twitter.com/RelayPHP)
- [Discord](https://discord.gg/exYBXqTXgY)
- [Discussions](https://github.com/cachewerk/relay/discussions)
- [API](https://relay.so/api)

## Known Issues

- [Inconsistent invalidations order](https://github.com/redis/redis/issues/8206) in Redis v6.2.6 and older

## Release

### Nightly

The `develop` branch is automatically pushed to R2 as nightly builds, mainly used by Homebrew.

### Tags

- Check out `develop`
- Update the [changelog](CHANGELOG.md)
- On `develop` update [`PHP_RELAY_VERSION`](src/php_relay.h)
- Make sure tests pass
- Dispatch an [artifact build](https://github.com/cachewerk/relay-core/actions/workflows/build.yml), wait for S3 upload, the make sure [Docker builds](https://github.com/cachewerk/relay/actions/workflows/docker.yml) pass
- Merge `develop` into `main`
- Create a release targeting `main` on `cachewerk/relay-core`
- Wait for [builds and uploads](https://github.com/cachewerk/relay-core/actions) to complete
- On `develop` bump [`PHP_RELAY_VERSION`](src/php_relay.h)

The release in `cachewerk/relay` will synchronized automatically.

Wait for the [assets to uploaded](https://github.com/cachewerk/relay-core/actions/workflows/upload-assets.yml), and then update the 3rd party repositories.

1. Bump all version references in [`cachewerk/relay`](https://github.com/cachewerk/relay)
2. Dispatch a `Build packages` workflow in [`cachewerk/linux-repos`](https://github.com/cachewerk/linux-repos)
3. Merge the PR created in [`cachewerk/homebrew-tap`](https://github.com/cachewerk/homebrew-tap)
4. Bump Relay version in [`cachewerk/heroku-php-extensions`](https://github.com/cachewerk/heroku-php-extensions)

### External

1. Update [`JetBrains/phpstorm-stubs`](https://github.com/JetBrains/phpstorm-stubs/tree/master/relay)
2. Update [`platformsh/snippets/README.md`](https://github.com/platformsh/snippets/blob/main/README.md) and [`platformsh/snippets/redis.md`](https://github.com/platformsh/platformsh-docs/blob/main/docs/src/languages/php/redis.md)
